 ; Ŀ
 ;   Mex - rid a drawing of Mtext.                                         
 ;   Copyright 2001, 2002, 2003 by Rocket Software Ltd.                    
 ;   Hey gringo, I don't like your mtext.                                  
 ; 

 ; Ŀ
 ;   Xylene - explode an entity, put resulting subentities on the layer    
 ;   which the original entity occupied.                                   
 ;   Takes one argument, an entity name.  Returns nothing.                 
 ; 
 (DEFUN XYLENE (enam / aaa eloi ss)
 ; Ŀ
 ;   Find the last entity in the drawing.                                  
 ; 
  (setq aaa (entlast))
  (while (entnext aaa)
         (setq aaa (entnext aaa)))
 ; Ŀ
 ;   Decide which layer the entity was on, explode it.                     
 ; 
  (setq eloi (cdr (assoc 8 (entget enam))))
  (command ".explode" enam)
 ; Ŀ
 ;   Find the debris left by the explosion.                                
 ; 
  (setq ss (ssadd))
  (while (setq aaa (entnext aaa))
         (ssadd aaa ss))
 ; Ŀ
 ;   Move the new ss to the original layer.                                
 ; 
  (if (< 0 (sslength ss)) (command ".change" ss "" "p" "la" eloi ""))
 (princ))
 ; Ŀ
 ;   Xylene end.                                                           
 ; 

 ; Ŀ
 ;   Vortex - mark a point passed as the only argument.                    
 ; 
 (DEFUN VORTEX (pa rad colo / reps pa rad2 angg incr)
  (if (= colo 0) (setq colo 4))
  (setq reps 75)
  (setq rad2 (* rad 2))
  (setq angg 0)
  (setq incr (/ pi (/ reps 2)))
  (repeat reps
          (setq ang2 (+ angg (/ pi 5)))
          (grdraw (polar pa angg rad2) (polar pa ang2 rad) colo)
          (setq angg (+ angg incr)))
 (princ))
 ; Ŀ
 ;   Vortex end.                                                           
 ; 

 ; Ŀ
 ;   Mex.                                                                  
 ; 
 (DEFUN C:MEX (/ ss num enam)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq rad (/ (getvar "viewsize") 35))
  (if (setq ss (ssget "X" (list (cons 0 "mtext"))))
      (progn
           (setq num 0)
           (while (setq enam (ssname ss num))
                  (setq entt (entget enam))
                  (setq pa (cdr (assoc 10 entt)))
                  (vortex pa rad num)
                  (xylene enam)
                  (setq num (1+ num)))
           (princ (itoa num))))
  (command "undo" "end")
 (princ))